<?php

if ( ! function_exists('redirect'))
{
	function redirect($path) 
	{
		$path = base_url() . $path;
		
		header('Location: ' . $path, TRUE);
	}
}

if ( ! function_exists('base_url'))
{
	function base_url()
	{
	  $url = sprintf(
	    "%s://%s%s",
	    isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
	    $_SERVER['SERVER_NAME'],
	    $_SERVER['REQUEST_URI']
	  );

	  $parts = explode('/',$url);
		$path = '';
		for ($i = 0; $i < count($parts) - 1; $i++) {
		 $path .= $parts[$i] . "/";
		}

	  if (strpos($path, '/' . ADMIN_FOLDER . '/') !== FALSE)
	  {
	  	$path = explode(ADMIN_FOLDER . '/', $path);
	  	$path = !empty($path[0]) ? $path[0] : NULL;
	  }

	  $port = $_SERVER['SERVER_PORT'];

	  if($port == 80 || $port == 443) {
	  	// Do nothing
	  } else {
	  	$path = substr($path, 0, -1) . ':'. $_SERVER['SERVER_PORT'] . '/';

	  }

	  return $path;
	}
}

if ( ! function_exists('input'))
{
	function input($name, $type='post') 
	{
		if(strtolower($type) == 'post')
		{
			return !empty($_POST[$name]) ? $_POST[$name] : NULL;
		}
		else
		{
			return !empty($_GET[$name]) ? $_GET[$name] : NULL;
		}
	}
}

/**
*
* Convert hexdec color string to rgb(a) string 
*/
if ( ! function_exists('hex2rgba'))
{
	function hex2rgba($color, $opacity = false) {

		$default = 'rgb(0,0,0)';

    //Return default if no color provided
		if(empty($color))
			return $default; 

    //Sanitize $color if "#" is provided 
		if ($color[0] == '#' ) {
			$color = substr( $color, 1 );
		}

        //Check if color has 6 or 3 characters and get values
		if (strlen($color) == 6) {
			$hex = array( $color[0] . $color[1], $color[2] . $color[3], $color[4] . $color[5] );
		} elseif ( strlen( $color ) == 3 ) {
			$hex = array( $color[0] . $color[0], $color[1] . $color[1], $color[2] . $color[2] );
		} else {
			return $default;
		}

        //Convert hexadec to rgb
		$rgb =  array_map('hexdec', $hex);

        //Check if opacity is set(rgba or rgb)
		if($opacity){
			if(abs($opacity) > 1)
				$opacity = 1.0;
			$output = 'rgba('.implode(",",$rgb).','.$opacity.')';
		} else {
			$output = 'rgb('.implode(",",$rgb).')';
		}

        //Return rgb(a) color string
		return $output;
	}
}


if ( ! function_exists('dd'))
{
	function dd($data) 
	{
		echo "<pre>"; print_r($data);
		exit;
	}
}

if ( ! function_exists('_e'))
{
	function _e($data) 
	{
		echo $data;
	}
}