<?php

require_once 'JsonDB.class.php';

class AppModel
{
	/**
	 * Properties
	 */
	private $_db;
	private $_tbl_api_key;
	private $_tbl_checklist;
	private $_tbl_settings;
	protected $root_docks_path;

	/**
	 * Constructor
	 */
	public function __construct()
	{
		$this->_db = new JsonDB(DB_FOLDER_PATH, FALSE);
		$this->_tbl_api_key = TBL_API;
		$this->_tbl_auth = TBL_AUTH;
		$this->_tbl_checklist = TBL_CHECKLISTS;
		$this->_tbl_settings = TBL_SETTINGS;

		$this->root_docks_path = $this->getRootPath()  . DIRECTORY_SEPARATOR;
	}

	/**
	 * Add a response to database
	 */
	public function saveSetting($data)
	{
		$this->_db->insert($this->_tbl_settings, $data);

		return TRUE;
	}

    public function saveAPI($data)
    {
        $this->_db->insert($this->_tbl_api_key, $data);

        return TRUE;
    }

    public function saveChecklist($data)
    {
        $this->_db->insert($this->_tbl_checklist, $data);

        return TRUE;
    }
	/**
	 * Add a response to database
	 */

    public function updateChecklist($data)
    {
        $this->_db->update($this->_tbl_checklist, 'id', $data['id'], $data);

        return TRUE;
    }

	public function updateDock($data)
	{
		$this->_db->update($this->_tbl_settings, 'id', $data['id'], $data);

		return TRUE;
	}

    public function updateAPI($data)
    {
        $this->_db->update($this->_tbl_api_key, 'id', $data['id'], $data);
        return TRUE;
    }


	public function deleteDockFolder($slug)
	{
		// Delete the folder
		$folder = $this->root_docks_path . $slug;

		if(!empty($slug)) {
			if(file_exists($folder)) {
				// Delete all files in the folder
				array_map('unlink', glob($folder . DIRECTORY_SEPARATOR . "*.*"));
				// Delete the folder
				rmdir( $folder );
			}
		}
	}

    public function manageTemplateFiles($data)
    {
        $file = dirname(__DIR__) .'/'. TEMPLATE_FILE ;

        $fh = fopen($file,"r+");

        fwrite($fh, $this->buildFileData($data,$file));
        fclose($fh);

        return true;
    }

    public function buildFileData($data,$filename)
    {

        // Read the template file
        $handle = fopen($filename, "r+");

        $contents = fread($handle, filesize($filename));
        fclose($handle);

        // 1. Replace the heading
        $contents = str_replace('{{heading}}', $data['heading'], $contents);
        // 2. Replace the sub-heading
        $contents = str_replace('{{sub-heading}}', $data['sub_heading'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu1}}', $data['menu1'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu2}}', $data['menu2'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu3}}', $data['menu3'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu4}}', $data['menu4'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu1url}}', $data['menu1url'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu2url}}', $data['menu2url'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu3url}}', $data['menu3url'], $contents);
        // 3. Replace the menu
        $contents = str_replace('{{menu4url}}', $data['menu4url'], $contents);

        // 3. Replace the menu
//        $contents = str_replace('{{menu4url}}', $data['menu4url'], $contents);
//        // 3. Replace the menu
//        $contents = str_replace('{{menu4url}}', $data['menu4url'], $contents);
//        // 3. Replace the menu
//        $contents = str_replace('{{menu4url}}', $data['menu4url'], $contents);
//        // 3. Replace the menu
//        $contents = str_replace('{{menu4url}}', $data['menu4url'], $contents);


        return $contents;
    }

	public function getRootPath()
	{
		$currentDirectoryPath = __DIR__;

		$pathDirectories = explode(DIRECTORY_SEPARATOR, $currentDirectoryPath);

		// Remove the last index
		unset($pathDirectories[count($pathDirectories) - 1]);

		return implode(DIRECTORY_SEPARATOR, $pathDirectories) . DIRECTORY_SEPARATOR;
	}

	/**
	 *All Docks
	 */
	public function getSettings()
	{
		try
		{
			return $this->_db->selectAll($this->_tbl_settings);
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}

	/**
	 * Single Dock Get
	 */
    public function getChecklist($id)
    {
        try
        {
            return $this->_db->select($this->_tbl_checklist, 'id', $id);
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }

    public function getChecklists()
    {
        try
        {
            return $this->_db->selectAll($this->_tbl_checklist);
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }

	public function getSetting($id)
	{
		try
		{
			return $this->_db->select($this->_tbl_settings, 'id', $id);
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}

    public function getAPI()

    {

        try
        {
            return $this->_db->selectAll($this->_tbl_api_key);
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }

	public function deleteDock($id)
	{
		try
		{
			$dock = $this->getSetting($id);
			$this->deleteDockFolder($dock[0]['slug']);

			return $this->_db->delete($this->_tbl_settings, 'id', $id);
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}

    public function deleteChecklist($id)
    {
        try
        {
            $dock = $this->getChecklist($id);

            return $this->_db->delete($this->_tbl_checklist, 'id', $id);
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }

    public function deleteapikey()
    {
        try
        {
            $id = $this->getAPI();
            return $this->_db->delete($this->_tbl_api_key, 'id', $id[0]['id']);
        }
        catch (Exception $e)
        {
            return FALSE;
        }
    }
	/**
	 * Add a response to database
	 */
	public function visit()
	{
		$data = array();
		$data['date'] = time();
		$this->_db->insert($this->_tbl_visits, $data);

		return TRUE;
	}

	/**
	 * visit count
	 */
	public function VisitCount()
	{
		try
		{
			$data = $this->_db->selectAll($this->_tbl_visits);

			return count($data);
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}

    public function curl($method = 'GET',$event ,$data = [])
    {

        $url = "https://app.kuicklist.com/api/v1/".$event;

        $curl = curl_init($url);

        if($method == 'GET')
        {
            curl_setopt($curl, CURLOPT_HTTPHEADER, array(
                'Kuick-List-Api-Key: '.$data['api_key']
            ));
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        }

        if($method == 'POST')
        {
            $key = $data['api_key'];

            curl_setopt($curl, CURLOPT_URL, $url.$key);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS,true);

        }

        // execute Curl
        $response = curl_exec($curl);

        // close the connection of Curl
        curl_close($curl);
        return $response;
    }

	/**
	 * Generate Unique User ID
	 */
	public function GenerateUserID()
	{
		return uniqid();
	}

	/**
	 * Generate Unique User ID
	 */
	public function generateUniqueID($prefix = '')
	{
		return $prefix . uniqid();
	}



    /**
     * Favicon image
     */
    public function uploadfavicon()
    {
        $allowedExts = array("png", "svg");

        $temp = explode(".", $_FILES["favicon"]["name"]);

        $extension = end($temp);

        if (( ($_FILES["favicon"]["type"] == "image/png")
                || ($_FILES["favicon"]["type"] == "image/svg"))
            && ($_FILES["favicon"]["size"] < 12000)
            && in_array($extension, $allowedExts)) {
            if ($_FILES["favicon"]["error"] > 0) {
                // Error
                return FALSE;
            } else {
                if (file_exists("/data/uploads/" . $_FILES["favicon"]["name"])) {
                    echo $_FILES["favicon"]["name"] . " already exists. ";
                } else {

                    $encryptedName = 'favicon';
                    $newFilename = $encryptedName.".".$extension;
                    $path = "data/uploads/";

                    move_uploaded_file($_FILES["favicon"]["tmp_name"], $path . $newFilename);
                    return $newFilename;
                }
            }
        } else {
            $_SESSION['message'] = "Favicon size must be less then 12 KB !";
            $_SESSION['msg_type'] = "danger";
            return false;
        }
    }


	/**
	 * Upload image
	 */
	public function uploadImage()
	{
		$allowedExts = array("gif", "jpeg", "jpg", "png");
		$temp = explode(".", $_FILES["popup_image"]["name"]);
		$extension = end($temp);

		if ((
			($_FILES["popup_image"]["type"] == "image/gif")
			|| ($_FILES["popup_image"]["type"] == "image/jpeg")
			|| ($_FILES["popup_image"]["type"] == "image/jpg")
			|| ($_FILES["popup_image"]["type"] == "image/pjpeg")
			|| ($_FILES["popup_image"]["type"] == "image/x-png")
			|| ($_FILES["popup_image"]["type"] == "image/png"))
			&& ($_FILES["popup_image"]["size"] < 1000000)
			&& in_array($extension, $allowedExts)) {
			if ($_FILES["popup_image"]["error"] > 0) {
				// Error
				return FALSE;
			} else {
				if (file_exists("/data/uploads/" . $_FILES["popup_image"]["name"])) {
					echo $_FILES["popup_image"]["name"] . " already exists. ";
				} else {

					$encryptedName = 'image'.time();
					$newFilename = $encryptedName.".".$extension;
					$path = "data/uploads/";

					move_uploaded_file($_FILES["popup_image"]["tmp_name"], $path . $newFilename);
					return $newFilename;
				}
			}
		} else {
            $_SESSION['message'] = "Logo size must be less then 1 MB !";
            $_SESSION['msg_type'] = "danger";
			return false;
		}
	}

	/**
	 * Auth Check
	 */
	public function authCheck($data)
	{
		try
		{
            $defaultUsername = 'admin';
            $defaultPassword = sha1('admin');

            $password = sha1($data['password']);

            $userData = $this->_db->selectAll($this->_tbl_auth);

            if(isset($userData)) {
                $defaultUsername = $userData[0]['username'];
                $defaultPassword = $userData[0]['password'];
            }

            if($defaultUsername == $data['username'] && $defaultPassword == $password)
            {
                if(isset($_SESSION['authError'])) unset($_SESSION['authError']);
                return TRUE;
            }
            else
            {
                $_SESSION['authError'] = TRUE;
                return FALSE;
            }
		}
		catch (Exception $e)
		{
			return FALSE;
		}

	}

	/**
	 * Check if user is logged-in
	 */
	public function isLoggedIn()
	{
		if(! isset($_SESSION['auth']))
		{
		    redirect('admin/login.php');
		    exit;
		}
		
	}


	/**
	 * Password update
	 */
	public function passUpdate($data)
	{
		try
		{
			$this->_db->deleteAll($this->_tbl_auth);
			$this->_db->insert($this->_tbl_auth, $data);

			return TRUE;
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}


	/**
	 * Delete all data from Answers and Visits JSON file(s)
	 */

	public function getUserData()

	{

		try
		{
			return $this->_db->selectAll($this->_tbl_auth);
		}
		catch (Exception $e)
		{
			return FALSE;
		}
	}

	
	public function isUniqueSlug($slug)
	{

		$docks = $this->getSettings();

		$isUnique = true;

		foreach ($docks as $dock) {
			if ($slug == $dock['slug']) {
				$isUnique = false;
				break;
			}
		}

		return $isUnique;
	}


} // End Model