<?php

class AppController
{
	/**
	 * Properties
	 */
	private $_data;
	private $_model;
	/**
	 * Constructor
	 */
	public function __construct($model)
	{

        $this->_model = $model;
	}

    public function account()
    {


        if(isset($_POST['submit']))
        {

            $password    = trim ($_POST['password']);
            $re_password = trim ($_POST['re_password']);
            $username 	= trim ($_POST['username']);

            if(empty($password) OR empty($re_password))
            {

                $data = array();
                $data['username']    = $username;
                $_SESSION['message'] = "Username has been updated.";
                $_SESSION['msg_type'] = "success";

            }else
            {
                if($password == $re_password)
                {
                    $data = array();
                    $data['password']    = sha1($password);
                    $data['username']    = $username;

                    $this->_model->passUpdate($data);

                    $_SESSION['message'] = "Password has been updated.";
                    $_SESSION['msg_type'] = "success";
                    redirect('admin/');
                }
                else
                {
                    // Show Error in view
                    $_SESSION['msg_type'] = "danger";
                    $_SESSION['message'] = "Confirm password' and 'Password' do not match.";
                    redirect('admin/my-account.php');
                }
            }


        }
    }


	/**
	 * Login Check
	 */
	public function auth()
	{


		if(isset($_POST['submit']))
		{

			$data= array();
			$data['username'] = $_POST['username'];
			$data['password'] = $_POST['password'];

			if($this->_model->authCheck($data))
			{
				$_SESSION['auth'] = TRUE;
				redirect('admin');
			}
			else
			{
				$_SESSION['error'] = "Wrong Username or/and Password.";
				$_SESSION['msg_type'] = "danger";
				redirect('admin/login.php');
			}
		}
	}

	/**
	 * Logout
	 */
	public function logout()
	{
		if(isset($_SESSION['auth']))

			session_destroy();
		
	}

	/**
	 * Account : Password Update
	 */
	public function api()
	{
		if(isset($_POST['submit']) && !empty($_POST['api_key']))
		{
            $old_api = $this->_model->getAPI();

            $api_key = $_POST['api_key'];

            if(!empty($old_api))
			{
                $data = array();
                $data['id']    = $old_api['id'];
                $data['api_key']    = $api_key;

                $response = $this->_model->curl('POST','verify-api-key?_kuick_list_api_key=',$data);
                if (!empty($response))
                {
                    $this->_model->updateAPI($data);

                    $_SESSION['message'] = "Api Key Has Been Updated !";
                    $_SESSION['msg_type'] = "success";
                    redirect('admin/api.php');

                }else
                {
                    $_SESSION['message'] = "Api Key Is Invalid !";
                    $_SESSION['msg_type'] = "danger";
                    redirect('admin/api.php');
                }

            }else
            {

                $data = array();
                $data['id']    = uniqid();
                $data['api_key']    = $api_key;

                $response = $this->_model->curl('POST','verify-api-key?_kuick_list_api_key=',$data);
                if (!empty($response))
                {
                    $this->_model->saveAPI($data);

                    $_SESSION['message'] = "Api Key Has Been Set !";
                    $_SESSION['msg_type'] = "success";
                    redirect('admin/api.php');

                }else
                    {
                        $_SESSION['message'] = "Api Key Is Invalid !";
                        $_SESSION['msg_type'] = "danger";
                        redirect('admin/api.php');
                    }


            }

        }else
            {
                $this->_model->deleteapikey();
                $_SESSION['message'] = "Api Key Has Been Updated !";
                $_SESSION['msg_type'] = "success";
                redirect('admin/api.php');
            }
	}

	/**
	 * Reset analytics data
	 */
	public function resetData()
	{
		$this->_model->resetData();
	}

	public function checklist_data($checklist)
    {
        foreach ($checklist as $check)
        {
            print_r($check);
        }
        exit;
        return $checklist;
    }

	public function saveSetting()
	{
		if(!empty($_POST)) {

			$data = array();

			$data['id'] = $this->_model->generateUniqueID('dock_');

            $data['title'] = $_POST['title'];
            $data['slug'] = preg_replace('/\s+/', '-', $_POST['title']);

            $alldocks = $this->_model->getDocks();

            foreach ($alldocks as $dock) {
                if($dock['slug'] === $data['slug']) {
                    $data['slug'] = $data['slug'].'-1';
                }
            }

            $this->_model->saveSetting($data);

            redirect('admin/settings.php?id=' . $data['id']);

        } else {
			redirect('admin');
		}
	}


	public function updatelist ()
    {
        $list = $this->_model->getSetting(1);

        if (!empty($list))
            {
                $data['id'] = 1;
                $data['heading'] = input('heading');
                $data['sub_heading'] = input('sub_heading');
                $data['menu1'] = input('menu1');
                $data['menu1url'] = input('menu1url');
                $data['menu2'] = input('menu2');
                $data['menu2url'] = input('menu2url');
                $data['menu3'] = input('menu3');
                $data['menu3url'] = input('menu3url');
                $data['menu4'] = input('menu4');
                $data['menu4url'] = input('menu4url');
                $data['pricolor'] = input('pricolor');
                $data['footer_text'] = input('footer_text');

                if(!empty($_FILES['popup_image']['tmp_name'])) {
                    $data['popup_image'] = $this->_model->uploadImage($data['id']);
                }else
                    {
                        $data['popup_image'] = $list[0]['popup_image'];
                    }

                if(!empty($_FILES['favicon']['tmp_name'])) {
                    $data['favicon'] = $this->_model->uploadfavicon($data['id']);
                }else
                {
                    $data['favicon'] = $list[0]['favicon'];
                }

                if (!empty(input('check_list')))
                {
                    $checklist['id'] = 1;
                    $checklist['checklist_id'] = input('check_list');
                    $this->_model->deleteChecklist(1);
                    $this->_model->saveChecklist($checklist);

                }else
                    {
                        $this->_model->deleteChecklist(1);
                    }
                $this->_model->updateDock($data);
                $this->_model->manageTemplateFiles($data);
            }else{

            $data['id'] = 1;
            $data['heading'] = input('heading');
            $data['sub_heading'] = input('sub_heading');
            $data['menu1'] = input('menu1');
            $data['menu1url'] = input('menu1url');
            $data['menu2'] = input('menu2');
            $data['menu2url'] = input('menu2url');
            $data['menu3'] = input('menu3');
            $data['menu3url'] = input('menu3url');
            $data['menu4'] = input('menu4');
            $data['menu4url'] = input('menu4url');
            $data['pricolor'] = input('pricolor');
            $data['footer_text'] = input('footer_text');

            if(!empty($_FILES['popup_image']['tmp_name'])) {
                $data['popup_image'] = $this->_model->uploadImage($data['id']);
            }

            if(!empty($_FILES['favicon']['tmp_name'])) {
                $data['favicon'] = $this->_model->uploadfavicon($data['id']);
            }

            if (!empty(input('check_list')))
            {
                $checklist['id'] = 1;
                $checklist['checklist_id'] = input('check_list');
                $this->_model->deleteChecklist(1);
                $this->_model->saveChecklist($checklist);
            }

            $this->_model->saveSetting($data);
            $this->_model->manageTemplateFiles($data);

        }
        $_SESSION['message'] = "List has been updated!";
        $_SESSION['msg_type'] = "success";
        redirect('admin/index.php');
    }



	public function deleteDock ()
	{
		if(!empty($_POST) && !empty($_POST['id'])) {

			$dock = $this->_model->deleteDock($_POST['id']);

			$_SESSION['message'] = "Dock has been Deleted successfully";
			$_SESSION['msg_type'] = "danger";

			redirect('admin');

		} else {
			redirect('admin');
		}
	}



// ------------------------------------------------------------------------
}