<?php
require_once 'libs/autoload.php';
$check_data = $model->getChecklists();
$setting =  $model->getSettings();

$db_api = $model->getAPI();
if(!empty($db_api))
{
    $api = $db_api[0];
}
?>

<!doctype html>
<html lang="en">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!--style CSS -->
    <link rel="stylesheet" href="assets/css/style.php">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link rel="stylesheet" href="assets/css/bootstrap.min.css">
    <link rel="stylesheet" href="assets/js/bootstrap.min.js">
    <?php echo !empty($setting[0]['favicon']) ? "<link rel='icon' type='image/png' href='data/uploads/".$setting[0]['favicon']."'>" : '' ?>

    <title>Lists</title>
</head>
<style>
    .modal-dialog {
        width: 100% !important;
        height: 100% !important;
        margin: 0 !important;
        padding: 0 !important;
        max-width:none !important;

    }

    .modal-content {
        height: auto !important;
        min-height: 100% !important;
        border-radius: 0 !important;
        background-color: #ffffff !important
    }

    .modal-footer {
        border-top: 1px solid #9ea2a2 !important;
    }

</style>
<body>
<div class="container-fluid">
    <div class="row header">
        <div class="col-sm-12 col-md-12 col-lg-2 logo">

            <?php if (!empty($setting[0]['popup_image']))
            {
                ?>
                <img src="data/uploads/<?php echo $setting[0]['popup_image'];?>" style="width: 100px; height: 50px;">
                <?php
            }?>

        </div>
        <div class="col-sm-12 col-md-12 col-lg-10 tabs">

            <ul>
                <?php
                if (isset($setting[0]['menu1'])){?>
                    <li><a href="<?php echo $setting[0]['menu1url'];?>"><?php echo $setting[0]['menu1']; ?></a></li>
                    <?php
                }
                if (isset($setting[0]['menu2'])){?>
                    <li><a href="<?php echo $setting[0]['menu2url'];?>"><?php echo $setting[0]['menu2']; ?></a></li>
                    <?php
                }
                if (isset($setting[0]['menu3'])){?>
                    <li><a href="<?php echo $setting[0]['menu3url'];?>"><?php echo $setting[0]['menu3']; ?></a></li>
                    <?php
                }
                if (isset($setting[0]['menu4'])){?>
                    <li><a href="<?php echo $setting[0]['menu4url'];?>"><?php echo $setting[0]['menu4']; ?></a></li>
                    <?php
                }
                ?>
            </ul>
        </div>
    </div>
    <div class="row main-container">
        <div class="col-sm-12 col-md-12 col-lg-12 content-heading" style="color: <?php _e(isset($setting[0]['pricolor']) ? $setting[0]['pricolor'] : '') ?>">
            <h2><?php echo $setting[0]['heading'];?></h2>
            <p><?php echo $setting[0]['sub_heading'];?></p>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row cards">

            <!-- Modal -->
            <div class="modal fade right" id="ModalPreview" tabindex="-1" role="dialog" aria-labelledby="exampleModalPreviewLabel" aria-hidden="true">
                <div class="modal-dialog momodel modal-fluid" role="document">
                    <div class="modal-content ">
                        <div class=" modal-header text-center">
                            <button  type="button" class="close " data-dismiss="modal" aria-label="Close">
                                <span style="font-size: 1.3em;" aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <img id="spinnergif" src="assets/images/25.gif" width="50px" height="40px" style="display: block; margin-top: 20%;  margin-left: auto;  margin-right: auto;">

                        <iframe id="ifrm" style="position:fixed; top: 66px; left:0; bottom:0; right:0; width:100%; height:100%; border:none; margin:0; padding:0; overflow:hidden; z-index:999999;">
                            Your browser doesn't support iframes
                        </iframe>
                    </div>
                </div>
            </div>
            <!-- Modal -->

            <?php
                if (!empty($api['api_key']))
                {
                    if (!empty($check_data))
                    {
                        //api call for checklist
                        $res = $model->curl('GET','checklists',$api);
                        $response = json_decode($res,true);
                        $data = array();
                        if (!empty($response['data']))
                        {
                            foreach ($response['data'] as $ch => $key)
                            {
                                if(in_array($key['id'],$check_data[0]['checklist_id'])) {
                                    $data[] = $key;
                                }
                            }
                            foreach ($data as $row)
                            {
                                ?>
                                <div class="col-sm-12 col-md-12 col-lg-4">
                                    <div class="card" style="color: <?php _e(isset($setting[0]['pricolor']) ? $setting[0]['pricolor'] : '') ?>">
                                        <a id="list_url" href="javascript:void(0)" data-url="<?php echo $row['url']; ?>" onclick="ifrm()" data-toggle="modal" data-target="#ModalPreview">
                                            <h3 style="color: <?php _e(isset($setting[0]['pricolor']) ? $setting[0]['pricolor'] : '') ?>"><?php echo $row['name']; ?></h3>
                                        </a>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                    }
                }
                ?>
        </div>
    </div>
    <div class="footer">
        <hr class="solid">
        <?php if (!empty($setting[0]['footer_text']))
        {
            ?>
            <p><?php echo $setting[0]['footer_text'];?></p>
            <?php
        }?>
    </div>
</div>
<?php include 'admin/common/footer.php' ?>
<script>
    $(document).ready(function () {
        $('a').click(function(event) {
            var id = $(this).attr('id');
            var url = $(this).attr('data-url');
            if (id == 'list_url') {
                event.preventDefault();
                //i want to prevent
                $('#ifrm').attr('src', url);
            } else {
                //redirect
            }
        });
    });
</script>
</body>
</html>