
let nav = document.querySelectorAll('.sidebar-nav li'),
	navbarTitle = document.querySelector('#navbar-title'),
	navbarTitleHeading = navbarTitle.querySelector('h5');

nav.forEach( li => {

	li.addEventListener('mouseover', showTitle);
	li.addEventListener('mouseleave', hideTitle);

});

function showTitle (e) {

	let nav = e.target;

	if (!nav.title) {

		if (nav.tagName === 'LI') 
			nav = nav.children[0];
		else
			nav = nav.parentNode;

	}

	let title = nav.title;
	
	navbarTitle.style.display = 'block';

	navbarTitleHeading.innerText = title;

	let navDimensions = nav.getBoundingClientRect();

	navbarTitle.style.left = navDimensions.width + 'px';
	navbarTitle.style.top = navDimensions.top + 'px';

}

function hideTitle () {

	navbarTitle.style.display = 'none';

}

$(document).ready(function () {

	var th = {
		init: function () {

			// initializing datepicker
			dp.init();

			// initializing charts
			ch.init();

			// initializing gallery
			// console.log($.hasOwnProperty('simpleLightbox'), $.simpleLightbox());
			if( $.isFunction( $.fn.simpleLightbox ) ) {
                $('.gallery a').simpleLightbox({
                    closeText: '<span style="font-size: 22px"><i class="far fa-times-circle"></i></span>'
                });
            }

			if ($('#example').length)
				$('#example').DataTable();

		}
	};

	var dp = {
		init: function () {

			// initializing input
			if ($('.datepicker'))
				$('.datepicker').datepicker({});

			// initializing component
			$('.input-group.date').datepicker({});

			// initializing daterange
			$('.input-daterange').datepicker({});

		}
	}

	var ch = {
		init: function () {
			
			if (typeof PAGE_NAME === 'undefined' || PAGE_NAME !== "dashboard")
				return;

			var presets = window.chartColors;
			var utils = Samples.utils;
			var inputs = {
				min: 1,
				max: 100,
				count: 8,
				decimals: 2,
				continuity: 1
			};

			function generateData(config) {
				return utils.numbers(Chart.helpers.merge(inputs, config || {}));
			}

			function generateLabels(config) {
				return utils.months(Chart.helpers.merge({
					count: inputs.count,
					section: 3
				}, config || {}));
			}

			var options = {
				maintainAspectRatio: false,
				spanGaps: false,
				elements: {
					line: {
						tension: 0.4
					}
				},
				plugins: {
					filler: {
						propagate: false
					}
				},
				scales: {
					xAxes: [{
						gridLines: {
							display: false,
							color: '#fff'
						},
						ticks: {
							fontColor: "#fff", // this here
		                },
					}],
					yAxes: [{
						gridLines: {
							display: false,
							color: '#fff'
						},
						ticks: {
							fontColor: "#fff", // this here
		                },
					}]
				},
				legend: {
					display: false,
				}
			};

			[
				{
					id: 'myChart-1', 
					color: '#fff',
					textColor: '#fff',
					type: 'line'
				},
				{
					id: 'myChart-2', 
					color: '#3772F6',
					textColor: '#ccc',
					type: 'bar'
				},
			].forEach(function (chart) {
				// reset the random seed to generate the same data for all charts
				utils.srand(8);

				new Chart(chart.id, {
					type: chart.type,
					data: {
						labels: generateLabels(),
						datasets: [{
							backgroundColor: chart.color,
							borderColor: chart.color,
							data: generateData(),
							fill: false
						}]
					},
					options: Chart.helpers.merge(options, {
						scales: {
							xAxes: [{
								gridLines: {
									display: false,
									color: chart.textColor
								},
								ticks: {
									fontColor: chart.textColor, // this here
				                },
							}],
							yAxes: [{
								gridLines: {
									display: false,
									color: chart.textColor
								},
								ticks: {
									fontColor: chart.textColor, // this here
				                },
							}]
						}
					})
				});

			});

		}
	}

	th.init();

	document.querySelector('body > div.wrapper > div.inner-wrapper > section > div.container-fluid > div > div > div.content-header > div.content-add');

});