<?php
header("Content-type: text/css; charset: UTF-8");
require_once '../../libs/autoload.php';
$setting =  $model->getSettings();

?>
body {
          margin: 0;
          font-family: MaryAnn, "Trebuchet MS", sans-serif!important;
          background: #f8f9fa !important;
        }

        .header {
          background-color: white;
          border-bottom: 1px solid lightgray;
        }

        .logo img {
          height: auto;
          width: 180px;
          min-height: 80px;
          padding: 10px;
        }

        .logo {
          display: flex;
          flex-direction: column;
          align-items: center;
        }

        li {
          float: right;
        }

        ul {
          list-style: none;
        }

        li a {
          display: block;
          color: #494848;
          text-align: center;
          padding: 30px;
          text-decoration: none;
          font-weight: 600;
        }

        li a:hover {
          color: <?php _e(isset($setting[0]['pricolor']) ? $setting[0]['pricolor'] : '') ?>;
          text-decoration: none;
        }

        ul :hover {
          border-bottom: 2px solid <?php _e(isset($setting[0]['pricolor']) ? $setting[0]['pricolor'] : '') ?>;
          background-color: rgba(15, 188, 61, .10);
        }

        .main-container {
          background-color: white;
        }

        .content-heading {
          margin-bottom: 50px;
          margin-top: 50px;
          padding: 10px;
          display: flex;
          flex-direction: column;
          align-items: center;
        }

        .content-heading h2 {
          font-weight: 700;
          font-size: 60px;
          font-family: MaryAnn, "Trebuchet MS", sans-serif!important;
        }

        .content-heading p {
          font-weight: 400;
          width: 35%;
          text-align: center;
          margin-top: 10px;
          color: #4c4c4c;
          font-size: 20px;
          line-height: 1.4;
        }

        .cards{
          margin: 30px !important;
        }

        .card {
          height: 310px !important;
          border: none !important;
          border-radius: 0 !important;
          box-shadow: 0 0 0 3px transparent;
          margin-top: 20px;
        }

        .card h3 {
          margin-top: 80px !important;
          padding: 40px;
          font-weight: 600;
          font-size: 26px;
          text-align: center;
        }

        .card a {
          text-decoration: none !important;
        }

        .footer p {
          text-align: center;
          color: gray;
          margin-bottom: 30px;
          margin-top: 30px;
          font-size: 12px;
        }

        hr {
          width: 93% !important;
        }

        @media only screen and (min-device-width: 320px) and (max-device-width: 768px) and (orientation:portrait) {
          li {
            float: none;
          }
          li a {
            padding: 20px;
            padding-right: 0 !important;
            padding-left: 0 !important;
          }
          ul {
            margin-right: 40px;
          }
          .content-heading h2 {
            font-size: 42px;
            text-align: center;
            padding: 12px;
          }
          .content-heading p {
            width: 75%;
            font-size: 18px;
          }
          .cards{
            margin-top: 30px;
            margin: 0 !important;
          }
          .card h3 {
            margin-top: 10px !important;
            padding-right: 20px;
            padding-left: 20px;
            font-size: 20px;
          }
          .card {
            margin-top: 30px;
            height: auto !important;
            min-height: 160px;
            margin-right: 0;
          }
        }

        @media only screen and (min-device-width: 768px) and (orientation:portrait) {
          .card h3{
            margin-top: 30px !important;
          }
        }
