<?php
require_once '../libs/autoload.php';
$model->isLoggedIn();

$_PAGE_TITLE = 'List Collections';

$check_data = $model->getChecklists();

$lists = $model->getSettings(1);
if (!empty($lists))
{
    $list = $lists[0];
}

$db_api = $model->getAPI();
if(!empty($db_api))
{
    $api = $db_api[0];
}
?>

<?php include 'common/head.php'; ?>

<style>
    .checkbox {
        padding-left: 20px;
    }

    .checkbox label {
        display: inline-block;
        position: relative;
        padding-left: 5px;
    }

    .checkbox label::before {
        content: "";
        display: inline-block;
        position: absolute;
        width: 17px;
        height: 17px;
        left: 0;
        margin-left: -20px;
        border: 1px solid #cccccc;
        border-radius: 3px;
        background-color: #fff;
        -webkit-transition: border 0.15s ease-in-out, color 0.15s ease-in-out;
        -o-transition: border 0.15s ease-in-out, color 0.15s ease-in-out;
        transition: border 0.15s ease-in-out, color 0.15s ease-in-out;
    }

    .checkbox label::after {
        display: inline-block;
        position: absolute;
        width: 16px;
        height: 16px;
        left: 0;
        top: 0;
        margin-left: -20px;
        padding-left: 3px;
        padding-top: 1px;
        font-size: 11px;
        color: #555555;
    }

    .checkbox input[type="checkbox"] {
        opacity: 0;
    }

    .checkbox input[type="checkbox"]:focus + label::before {
        outline: thin dotted;
        outline: 5px auto -webkit-focus-ring-color;
        outline-offset: -2px;
    }

    .checkbox input[type="checkbox"]:checked + label::after {
        font-family: 'FontAwesome';
        content: "\f00c";
    }

    .checkbox input[type="checkbox"]:disabled + label {
        opacity: 0.65;
    }

    .checkbox input[type="checkbox"]:disabled + label::before {
        background-color: #eeeeee;
        cursor: not-allowed;
    }

    .checkbox-success input[type="checkbox"]:checked + label::before {
        background-color: #5cb85c;
        border-color: #5cb85c;
    }

    .checkbox-success input[type="checkbox"]:checked + label::after {
        color: #fff;
    }
</style>
<link href="//cdnjs.cloudflare.com/ajax/libs/font-awesome/3.2.1/css/font-awesome.min.css" rel="stylesheet"/>
<body>

<div class="wrapper">
    <div class="inner-wrapper">

        <!-- Navigation -->
        <?php include 'common/sidebar.php'; ?>
        <!-- End Navigation -->

        <section class="page-content">
            <div class="container-fluid">
                <div class="content-wrapper">
                    <div class="content">
                        <!-- Tabs -->

                        <div class="content-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="box shadow-light br-8">

                                        <?php

                                        if (isset($_SESSION['message'])): ?>

                                            <div class="alert alert-<?= $_SESSION['msg_type'] ?>">

                                                <?php
                                                echo $_SESSION['message'];
                                                unset($_SESSION['message']);
                                                ?>

                                            </div>
                                        <?php endif ?>

                                        <?php if (!empty($api['api_key']))
                                        {
                                            $res = $model->curl('GET','checklists',$api);
                                            $response = json_decode($res,true);
                                            ?>

                                            <form method="POST"
                                                  action="<?php echo base_url(); ?>router.php?action=updatelist"
                                                  enctype="multipart/form-data">

                                                <div class="separator">
                                                    <div>
                                                        <i class="fas fa-list d-inline-block ml-2"
                                                           style="font-size: 24px; color: #0FBC3D;"></i>
                                                        <p class="h4 pl-2 d-inline-block">Lists Collection
                                                        </p>
                                                    </div>

                                                    <div class="separator">
                                                        <i class="fas fa-cog d-inline-block ml-2"
                                                           style="font-size: 24px; color: #0FBC3D;"></i>
                                                        <p class="h4 pl-2 d-inline-block">General
                                                        </p>
                                                    </div>
                                                    <div class="separator">
                                                        <?php include 'common/alerts.php'; ?>
                                                        <div class="form-group col-md-12 p-2 pl-2 pr-5">
                                                            <label for="heading">Heading</label>
                                                            <input type="text" class="form-control" name="heading"
                                                                   id="heading" value="<?php _e(isset($list['heading']) ? $list['heading'] : '') ?>">
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-12 p-2 pl-3 pr-5">
                                                                <label for="sub-heading">Sub-Heading</label>
                                                                <input type="text" class="form-control" name="sub_heading"
                                                                       id="sub-heading" value="<?php _e(isset($list['sub_heading']) ? $list['sub_heading'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu1">Titile</label>
                                                                <input type="text" class="form-control" name="menu1" id="menu1" value="<?php _e(isset($list['menu1']) ? $list['menu1'] : '') ?>">
                                                            </div>
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu1url">(Url) 1</label>
                                                                <input type="url" class="form-control" name="menu1url"
                                                                       id="menu1url" value="<?php _e(isset($list['menu1url']) ? $list['menu1url'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu2">Title</label>
                                                                <input type="text" class="form-control" name="menu2"
                                                                       id="menu2" value="<?php _e(isset($list['menu2']) ? $list['menu2'] : '') ?>">
                                                            </div>

                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu2url">(Url) 2</label>
                                                                <input type="url" class="form-control" name="menu2url"
                                                                       id="menu2url" value="<?php _e(isset($list['menu2url']) ? $list['menu2url'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu3">Title</label>
                                                                <input type="text" class="form-control" name="menu3"
                                                                       id="menu3" value="<?php _e(isset($list['menu3']) ? $list['menu3'] : '') ?>">
                                                            </div>

                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu3url">(Url) 3</label>
                                                                <input type="url" class="form-control" name="menu3url"
                                                                       id="menu3url" value="<?php _e(isset($list['menu3url']) ? $list['menu3url'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu4">Title</label>
                                                                <input type="text" class="form-control" name="menu4"
                                                                       id="menu4" value="<?php _e(isset($list['menu4']) ? $list['menu4'] : '') ?>">
                                                            </div>

                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="menu4url">(Url) 4</label>
                                                                <input type="url" class="form-control" name="menu4url"
                                                                       id="menu4url" value="<?php _e(isset($list['menu4url']) ? $list['menu4url'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="favicon">Favicon&nbsp;	&nbsp;	</label>
                                                                <br>
                                                                <br>
                                                                <input type="file" id="favicon" name="favicon" accept=".png, .svg,">
                                                            </div>
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                <label for="popup_image">Logo&nbsp;	&nbsp;	</label>
                                                                <br>
                                                                <br>
                                                                <input type="file" id="popup_image" name="popup_image" accept=".jpg, .jpeg, .png">
                                                            </div>
                                                        </div>
                                                        <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5 mt-2">
                                                                <p>Select Primary Color</p>
                                                                <input type="color" name="pricolor" value="<?php _e(isset($list['pricolor']) ? $list['pricolor'] : '') ?>">
                                                            </div>
                                                        </div>
                                                        <br>
                                                        <div class="col-md-12">
                                                            <hr>
                                                        </div>
                                                        <div class="separator">
                                                            <div>
                                                                <i class="fas fa-plug d-inline-block ml-2"
                                                                   style="font-size: 24px; color: #0FBC3D;"></i>
                                                                <p class="h4 pl-2 d-inline-block">Lists</p>
                                                            </div>
                                                            <div class="separator">
                                                                <div class="form-group col-md-12 p-2 pr-5">
                                                                    <fieldset>
                                                                        <?php
                                                                        if (!empty($response['data']))
                                                                        {
                                                                            if (!empty($check_data))
                                                                            {
                                                                                foreach ($response['data'] as $row => $key)
                                                                                {
//                                                                                    ?>
                                                                                    <div class="checkbox checkbox-success">
                                                                                        <input id="<?php echo $key['id']; ?>" name="check_list[]" type="checkbox" value="<?php echo $key['id']; ?>" <?php echo in_array($key['id'],$check_data[0]['checklist_id']) ? 'checked' : '' ?>>
                                                                                        <label for="<?php echo $key['id']; ?>">
                                                                                            <?php echo $key['name']; ?>
                                                                                        </label>
                                                                                    </div>
                                                                                    <br>
                                                                                    <?php

                                                                                }
                                                                            }else{
                                                                                foreach ($response['data'] as $row => $key)
                                                                                {
                                                                            ?>
                                                                            <div class="checkbox checkbox-success">
                                                                                <input id="<?php echo $key['id']; ?>" name="check_list[]" type="checkbox" value="<?php echo $key['id']; ?>" >
                                                                                <label for="<?php echo $key['id']; ?>">
                                                                                    <?php echo $key['name']; ?>
                                                                                </label>
                                                                            </div>
                                                                            <br>
                                                                            <?php
                                                                        }
                                                                        }
                                                                        }else
                                                                            {
                                                                               ?>
                                                                                <div class="alert alert-warning" role="alert">Not Found Any Checklist !</div>
                                                                        <?php
                                                                            }
                                                                        ?>
                                                                    </fieldset>
                                                                </div>
                                                                <div class="separator">
                                                                    <div>
                                                                        <i class="fas fa-shoe-prints d-inline-block ml-2"
                                                                           style="font-size: 24px; color: #0FBC3D;"></i>
                                                                        <p class="h4 pl-2 d-inline-block">Footer</p>
                                                                    </div>

                                                                    <div id="btn-opt-in">

                                                                        <div class="form-group col-md-12 p-2 pl-3 pr-5">
                                                                            <label for="name-title">Footer Text</label>
                                                                            <input type="text" class="form-control"
                                                                                   name="footer_text" id="footer_text" value="<?php _e(isset($list['footer_text']) ? $list['footer_text'] : '') ?>">
                                                                        </div>
                                                                    </div>



                                                                    <div class="separator">
                                                                        <br>
                                                                        <div class="float-right">
                                                                            <button type="submit" class="btn btn-primary ">
                                                                                Submit
                                                                            </button>
                                                                        </div>
                                                                        <br>
                                                                        <!-- </form> -->
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </form>

                                            <?php

                                        }else
                                            {
                                                ?>
                                                <div class="alert alert-warning">
                                                    Kindly Set Api First For Checklist !
                                                </div>
                                                <form method="POST"
                                                      action="<?php echo base_url(); ?>router.php?action=updatelist"
                                                      enctype="multipart/form-data">
                                                    <div class="separator">
                                                        <div>
                                                            <i class="fas fa-list d-inline-block ml-2"
                                                               style="font-size: 24px; color: #0FBC3D;"></i>
                                                            <p class="h4 pl-2 d-inline-block">Lists Collection
                                                            </p>
                                                        </div>

                                                        <div class="separator">
                                                            <i class="fas fa-cog d-inline-block ml-2"
                                                               style="font-size: 24px; color: #0FBC3D;"></i>
                                                            <p class="h4 pl-2 d-inline-block">General
                                                            </p>
                                                        </div>

                                                        <div class="separator">
                                                            <?php include 'common/alerts.php'; ?>
                                                            <div class="form-group col-md-12 p-2 pl-2 pr-5">
                                                                <label for="heading">Heading</label>
                                                                <input type="text" class="form-control" name="heading"
                                                                       id="heading"
                                                                       value="<?php _e(isset($list['heading']) ? $list['heading'] : '') ?>">
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-12 p-2 pl-3 pr-5">
                                                                    <label for="sub-heading">Sub-Heading</label>
                                                                    <input type="text" class="form-control" name="sub_heading"
                                                                           id="sub-heading" value="<?php _e(isset($list['sub_heading']) ? $list['sub_heading'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu1">Title</label>
                                                                    <input type="text" class="form-control" name="menu1" id="menu1" value="<?php _e(isset($list['menu1']) ? $list['menu1'] : '') ?>">
                                                                </div>
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu1url">(Url) 1</label>
                                                                    <input type="text" class="form-control" name="menu1url"
                                                                           id="menu1url" value="<?php _e(isset($list['menu1url']) ? $list['menu1url'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu2">Title</label>
                                                                    <input type="text" class="form-control" name="menu2"
                                                                           id="menu2" value="<?php _e(isset($list['menu2']) ? $list['menu2'] : '') ?>">
                                                                </div>

                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu2url">(Url) 2</label>
                                                                    <input type="text" class="form-control" name="menu2url"
                                                                           id="menu2url" value="<?php _e(isset($list['menu2url']) ? $list['menu2url'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu3">Title</label>
                                                                    <input type="text" class="form-control" name="menu3"
                                                                           id="menu3" value="<?php _e(isset($list['menu3']) ? $list['menu3'] : '') ?>">
                                                                </div>

                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu3url">(Url) 3</label>
                                                                    <input type="text" class="form-control" name="menu3url"
                                                                           id="menu3url" value="<?php _e(isset($list['menu3url']) ? $list['menu3url'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu4">Title</label>
                                                                    <input type="text" class="form-control" name="menu4"
                                                                           id="menu4" value="<?php _e(isset($list['menu4']) ? $list['menu4'] : '') ?>">
                                                                </div>

                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="menu4url">(Url) 4</label>
                                                                    <input type="text" class="form-control" name="menu4url"
                                                                           id="menu4url" value="<?php _e(isset($list['menu4url']) ? $list['menu4url'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                            <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                    <label for="image_uploads">Favicon&nbsp;	&nbsp;	</label>
                                                                <br>
                                                                <br>
                                                                    <input type="file" id="favicon" name="favicon" accept=".png, .svg">
                                                            </div>
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5">
                                                                        <label for="image_uploads">Logo&nbsp;	&nbsp;	</label>
                                                                    <br>
                                                                    <br>
                                                                        <input type="file" id="popup_image" name="popup_image" accept=".jpg, .jpeg, .png">
                                                                </div>
                                                            </div>
                                                            <div class="form-row">
                                                                <div class="form-group col-md-6 p-2 pl-3 pr-5 mt-2">
                                                                    <p>Select Primary Color</p>
                                                                    <input type="color" name="pricolor" value="<?php _e(isset($list['pricolor']) ? $list['pricolor'] : '') ?>">
                                                                </div>
                                                            </div>
                                                            
                                                            <div class="separator">
                                                                <div>
                                                                    <i class="fas fa-plug d-inline-block ml-2"
                                                                       style="font-size: 24px; color: #0FBC3D;"></i>
                                                                    <p class="h4 pl-2 d-inline-block">Lists</p>
                                                                </div>
                                                                <div class="separator">
                                                                    <div class="form-group col-md-12 p-2 pr-5">

                                                                    </div>
                                                                    <div class="separator">
                                                                        <div>
                                                                            <i class="fas fa-shoe-prints d-inline-block ml-2"
                                                                               style="font-size: 24px; color: #0FBC3D;"></i>
                                                                            <p class="h4 pl-2 d-inline-block">Footer</p>
                                                                        </div>

                                                                        <div id="btn-opt-in">

                                                                            <div class="form-group col-md-12 p-2 pl-3 pr-5">
                                                                                <label for="name-title">Footer Text</label>
                                                                                <input type="text" class="form-control"
                                                                                       name="footer_text" id="footer_text" value="<?php _e(isset($list['footer_text']) ? $list['footer_text'] : '') ?>">
                                                                            </div>
                                                                        </div>

                                                                        <div class="separator">
                                                                            <br>
                                                                            <div class="float-right">
                                                                                <button type="submit" class="btn btn-primary ">
                                                                                    Submit
                                                                                </button>
                                                                            </div>
                                                                            <br>
                                                                            <!-- </form> -->
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                                <?php
                                            }
                                            ?>

                                    </div>
                                </div>

                                <div class="col-md-6  preview-card shadow-light" id="preview-section"
                                     style="height: 488px;">


                                    <!-- <div class="box shadow-light" style="height: 600px;" > -->


                                    <style type="text/css">
                                        .mockup-img {

                                            vertical-align: middle;
                                            border-style: none;

                                        }

                                        .preview-card {
                                            padding: 0 !important;
                                        }


                                        #dock-preview-iframe-container iframe {
                                            width: 177%;
                                            min-height: 1320px;
                                            height: 100%;
                                            border: 0;
                                            /*zoom: 1.5; */
                                            -ms-transform: scale(0.565);
                                            -moz-transform: scale(0.565);
                                            -o-transform: scale(0.565);
                                            -webkit-transform: scale(0.565);
                                            transform: scale(0.565);
                                            -ms-transform-origin: 0 0;
                                            -moz-transform-origin: 0 0;
                                            -o-transform-origin: 0 0;
                                            -webkit-transform-origin: 0 0;
                                            transform-origin: 0 0;
                                            border-left: 2px solid #F1F1F1;
                                            border-right: 2px solid #F1F1F1;
                                            border-bottom: 2px solid #F1F1F1;
                                        }

                                        @supports not (-webkit-overflow-scrolling: touch) {
                                            #dock-preview-iframe-container {
                                                overflow: visible;
                                            }
                                        }

                                        @media screen and (-ms-high-contrast: active), (-ms-high-contrast: none) {
                                            #dock-preview-iframe-container {
                                                overflow: visible;
                                            }
                                        }

                                        @media (max-width: 767px) {

                                            #preview-section {
                                                margin-top: 20px !important;
                                            }
                                        }

                                    </style>


                                    <img class="mockup-img" src="https://ui.kuick.co/images/chrome-mockup.png"
                                         style="width: 100%;">
                                    <div id="dock-preview-iframe-container">
                                        <iframe src="../index.php" allowfullscreen
                                                mozallowfullscreen webkitallowfullscreen>Your browser doesn't support
                                            iFrames.
                                        </iframe>
                                    </div>


                                    <!-- <p> Preview Not Available </p> -->

                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
    </div>
    </section>
</div>
</div>

</body>
<?php include 'common/footer.php' ?>
<script>
    $(document).ready(function () {
        $('#favicon').on('change', function() {

            //this.files[0].size gets the size of your file.
            var size = this.files[0].size;
            var limit = 12000;
            if (size>limit)
            {
                alert("file size exceeds the limit allowed and cannot be saved (12KB limit)")
                $('#favicon').val('');
                return false;
            }
        });

        $('#popup_image').on('change', function() {

            //this.files[0].size gets the size of your file.
            var size = this.files[0].size;
            var limit = 1000000;
            if (size>limit)
            {
                alert("file size exceeds the limit allowed and cannot be saved (1MB limit)")
                $('#popup_image').val('');
                return false;
            }
        });
    });
</script>