<?php
require_once '../libs/autoload.php';

$model->isLoggedIn();

$_PAGE_TITLE = 'Api Integration';

$db_api = $model->getAPI();
if (!empty($db_api))
{
    $api = $db_api[0];
}
?>

<?php include 'common/head.php'; ?>

<body>

<div class="wrapper">

    <div class="inner-wrapper">

        <!-- Navigation -->
        <?php include 'common/sidebar.php'; ?>
        <!-- End Navigation -->

        <!-- Content -->
        <section class="page-content">
            <div class="container-fluid">

                <div class="content-wrapper">

                    <div class="content">

                        <!-- Content Header -->
                        <div class="content-header">

                            <div class="content-heading">

                                <div class="heading-icon d-flex justify-content-center align-items-center">
                                    <i class="fas fa-plug"></i>
                                </div>

                                <div class="heading-text">
                                    <h3>Api Integration</h3>
                                    <p>Add Api Credentials To Connect</p>
                                </div>

                            </div>


                        </div>
                        <!-- End Content Header -->

                        <!-- Content Body -->
                        <div class="content-body">

                            <div class="row">

                                <div class="col-md-6">

                                    <div class="box shadow-light br-8">


                                        <?php

                                        if (isset($_SESSION['message'])): ?>

                                            <div class="alert alert-<?= $_SESSION['msg_type'] ?>">

                                                <?php
                                                echo $_SESSION['message'];
                                                unset($_SESSION['message']);
                                                ?>

                                            </div>
                                        <?php endif ?>

                                        <div>

                                            <div class="separator">

                                                <form method="POST"
                                                      action="<?php echo base_url(); ?>router.php?action=api">
                                                    <input type="hidden" value="<?php _e(isset($api['id']) ? $api['id'] : '') ?>" name="id">
                                                    <div class="form-group col-md-8">
                                                        <label>Api Key</label>
                                                        <input type="text" name="api_key" class="form-control"
                                                               placeholder="Key-xxxx" value="<?php _e(isset($api['api_key']) ? $api['api_key'] : '') ?>">
                                                    </div>

                                                    <div class="col-md-12">
                                                        <button type="submit" name="submit"
                                                                class="btn btn-primary btn-fill float-right"><?php _e(isset($api['api_key']) ? 'Update' :'Connect');?>
                                                        </button>
                                                    </div>

                                                    <br>

                                                </form>

                                            </div>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </div>
                        <!-- End Content Body -->

                    </div>

                </div>

            </div>
        </section>
        <!-- End Content -->

    </div>

</div>
<script type="text/javascript" src="assets/js/jquery-3.3.1.min.js"></script>
<script type="text/javascript" src="assets/js/bootstrap.min.js"></script>
<script type="text/javascript" src="assets/js/bootstrap-datepicker.min.js"></script>
<script type="text/javascript" src="assets/js/custom.js"></script>

</body>
</html>